/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import ibm.nways.jdm8273.model.AtmxElanModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class ElanInfoBasePanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "LEC Configurations";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel AtmxElan_model;
    protected ElanSelSection ElanSelPropertySection;
    protected ElanCfgSection ElanCfgPropertySection;
    protected ElanCfgTimersSection ElanCfgTimersPropertySection;
    protected ModelInfo ElanTableInfo;
    protected ModelInfo ElanDetailsInfo;
    protected int ElanTableIndex;
    protected ElanTable ElanTableData;
    protected TableColumns ElanTableColumns;
    protected TableStatus ElanTableStatus;
    protected static TableColumn[] ElanTableCols = new TableColumn[]{new TableColumn("Index.Index", "Index", 3, true), new TableColumn("ElanDetails.ElanLanType", "LAN Type", 16, false), new TableColumn("ElanDetails.ElanLanName", "LAN Name", 5, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.jdm8273.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm8273.eui.ElanInfoBasePanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel ElanInfoBase");
        }
    }

    public static String getTitle() {
        ElanInfoBasePanel.loadStatics();
        if (myResources != null) {
            title = ElanInfoBasePanel.getNLSString("ElanInfoBasePanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            ElanInfoBasePanel.loadStatics();
        }
        return enumStrings;
    }

    public ElanInfoBasePanel() {
        ElanInfoBasePanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return ElanInfoBasePanel.getTitle();
    }

    protected void getModels() {
        this.AtmxElan_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addElanSelSection();
        this.addElanCfgSection();
        this.addElanCfgTimersSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addElanSelSection() {
        this.ElanSelPropertySection = new ElanSelSection();
        this.ElanSelPropertySection.layoutSection();
        this.addSection(ElanInfoBasePanel.getNLSString("ElanSelSectionTitle"), this.ElanSelPropertySection);
    }

    protected void addElanCfgSection() {
        this.ElanCfgPropertySection = new ElanCfgSection();
        this.ElanCfgPropertySection.layoutSection();
        this.addSection(ElanInfoBasePanel.getNLSString("ElanCfgSectionTitle"), this.ElanCfgPropertySection);
    }

    protected void addElanCfgTimersSection() {
        this.ElanCfgTimersPropertySection = new ElanCfgTimersSection();
        this.ElanCfgTimersPropertySection.layoutSection();
        this.addSection(ElanInfoBasePanel.getNLSString("ElanCfgTimersSectionTitle"), this.ElanCfgTimersPropertySection);
    }

    protected void panelRowChange() {
        if (this.ElanSelPropertySection != null) {
            this.ElanSelPropertySection.rowChange();
        }
        if (this.ElanCfgPropertySection != null) {
            this.ElanCfgPropertySection.rowChange();
        }
        if (this.ElanCfgTimersPropertySection != null) {
            this.ElanCfgTimersPropertySection.rowChange();
        }
    }

    public void filterElanDetailsInfos(Vector vector) {
    }

    public int getInitialElanTableRow() {
        return 0;
    }

    public ModelInfo initialElanTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(ElanInfoBasePanel.getNLSString("startResetMsg"));
        this.ElanTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(ElanInfoBasePanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(ElanInfoBasePanel.getNLSString("endResetMsg")) + " " + ElanInfoBasePanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.ElanDetailsInfo = new ModelInfo();
        this.ElanDetailsInfo.add("Index.Index", (Serializable)this.ElanTableData.getValueAt("Index.Index", this.ElanTableIndex));
        this.errorsFound = false;
        this.displayMsg(ElanInfoBasePanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.ElanTableInfo = (ModelInfo)this.ElanTableData.elementAt(this.ElanTableIndex);
            this.ElanTableInfo = this.ElanTableData.setRow();
            this.ElanTableData.setElementAt(this.ElanTableInfo, this.ElanTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(ElanInfoBasePanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(ElanInfoBasePanel.getNLSString("endApplyMsg")) + " " + ElanInfoBasePanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(ElanInfoBasePanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.ElanTableData = new ElanTable();
        this.ElanTableIndex = 0;
        this.ElanTableColumns = new TableColumns(ElanTableCols);
        if (this.AtmxElan_model instanceof RemoteModelWithStatus) {
            try {
                this.ElanTableStatus = (TableStatus)this.AtmxElan_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class ElanSelSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component ElanTableField;
        Label ElanTableFieldLabel;
        boolean ElanTableFieldWritable = false;

        public ElanSelSection() {
            ElanInfoBasePanel.this = ElanInfoBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createElanTableField() {
            EuiGrid euiGrid = new EuiGrid(ElanInfoBasePanel.this.ElanTableData, ElanInfoBasePanel.this.ElanTableColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(ElanInfoBasePanel.this.initialElanTableRow());
            this.addTable(ElanInfoBasePanel.getNLSString("ElanTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.ElanTableField = this.createElanTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                ElanInfoBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("accessDataMsg"));
            ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.ElanTableField).refresh();
            ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("endTableGetMsg"));
            ElanInfoBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.ElanTableField) {
                        ElanInfoBasePanel.this.ElanTableIndex = euiGridEvent.getRow();
                    }
                    ElanInfoBasePanel.this.ElanTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.ElanTableField).deselectAllRows();
                    ElanInfoBasePanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.ElanTableField) {
                        ElanInfoBasePanel.this.ElanTableIndex = 0;
                    }
                    ElanInfoBasePanel.this.ElanSelPropertySection.reset();
                    ElanInfoBasePanel.this.ElanCfgPropertySection.reset();
                    ElanInfoBasePanel.this.ElanCfgTimersPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class ElanCfgSection
    extends PropertySection {
        ModelInfo chunk;
        Component elanIndexField;
        Component elanLanNameField;
        Component elanLanTypeField;
        Component elanMaxDataFrameSizeField;
        Component elanConfigModeField;
        Component elanUseDefaultLecsAddrField;
        Component elanLecsAtmAddressField;
        Component elanLesAtmAddressField;
        Label elanIndexFieldLabel;
        Label elanLanNameFieldLabel;
        Label elanLanTypeFieldLabel;
        Label elanMaxDataFrameSizeFieldLabel;
        Label elanConfigModeFieldLabel;
        Label elanUseDefaultLecsAddrFieldLabel;
        Label elanLecsAtmAddressFieldLabel;
        Label elanLesAtmAddressFieldLabel;
        boolean elanIndexFieldWritable = false;
        boolean elanLanNameFieldWritable = false;
        boolean elanLanTypeFieldWritable = false;
        boolean elanMaxDataFrameSizeFieldWritable = false;
        boolean elanConfigModeFieldWritable = false;
        boolean elanUseDefaultLecsAddrFieldWritable = false;
        boolean elanLecsAtmAddressFieldWritable = false;
        boolean elanLesAtmAddressFieldWritable = false;

        public ElanCfgSection() {
            ElanInfoBasePanel.this = ElanInfoBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createelanIndexField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanIndex.access", "read-only");
            this.elanIndexFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanIndexFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanIndexLabel"), 2);
            if (this.elanIndexFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.elanIndexFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanIndexFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanIndexField);
            this.validateelanIndexField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanIndexField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanIndexField);
                jDMInput.setValue(object);
                this.validateelanIndexField();
            }
        }

        protected boolean validateelanIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanIndexField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanIndexFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanIndexFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanLanNameField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLanName.access", "read-write");
            String string2 = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLanName.length", "32");
            this.elanLanNameFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanLanNameFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanLanNameLabel"), 2);
            if (this.elanLanNameFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.elanLanNameFieldLabel, (Component)stringInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanLanNameFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanLanNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLanNameField);
            this.validateelanLanNameField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanLanNameField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanLanNameField);
                jDMInput.setValue(object);
                this.validateelanLanNameField();
            }
        }

        protected boolean validateelanLanNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLanNameField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanLanNameFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanLanNameFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanLanTypeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLanType.access", "read-write");
            this.elanLanTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanLanTypeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanLanTypeLabel"), 2);
            if (this.elanLanTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxElanModel.ElanDetails.ElanLanTypeEnum.symbolicValues, AtmxElanModel.ElanDetails.ElanLanTypeEnum.numericValues, ElanInfoBasePanel.getEnumStrings());
                this.addRow(this.elanLanTypeFieldLabel, (Component)singleChoiceInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxElanModel.ElanDetails.ElanLanTypeEnum.symbolicValues, AtmxElanModel.ElanDetails.ElanLanTypeEnum.numericValues, ElanInfoBasePanel.getEnumStrings());
            this.addRow(this.elanLanTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getelanLanTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLanTypeField);
            this.validateelanLanTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanLanTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanLanTypeField);
                jDMInput.setValue(object);
                this.validateelanLanTypeField();
            }
        }

        protected boolean validateelanLanTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLanTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanLanTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanLanTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanMaxDataFrameSizeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanMaxDataFrameSize.access", "read-write");
            this.elanMaxDataFrameSizeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanMaxDataFrameSizeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanMaxDataFrameSizeLabel"), 2);
            if (this.elanMaxDataFrameSizeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxElanModel.ElanDetails.ElanMaxDataFrameSizeEnum.symbolicValues, AtmxElanModel.ElanDetails.ElanMaxDataFrameSizeEnum.numericValues, ElanInfoBasePanel.getEnumStrings());
                this.addRow(this.elanMaxDataFrameSizeFieldLabel, (Component)singleChoiceInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxElanModel.ElanDetails.ElanMaxDataFrameSizeEnum.symbolicValues, AtmxElanModel.ElanDetails.ElanMaxDataFrameSizeEnum.numericValues, ElanInfoBasePanel.getEnumStrings());
            this.addRow(this.elanMaxDataFrameSizeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getelanMaxDataFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxDataFrameSizeField);
            this.validateelanMaxDataFrameSizeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanMaxDataFrameSizeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanMaxDataFrameSizeField);
                jDMInput.setValue(object);
                this.validateelanMaxDataFrameSizeField();
            }
        }

        protected boolean validateelanMaxDataFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxDataFrameSizeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanMaxDataFrameSizeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanMaxDataFrameSizeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanConfigModeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanConfigMode.access", "read-write");
            this.elanConfigModeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanConfigModeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanConfigModeLabel"), 2);
            if (this.elanConfigModeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxElanModel.ElanDetails.ElanConfigModeEnum.symbolicValues, AtmxElanModel.ElanDetails.ElanConfigModeEnum.numericValues, ElanInfoBasePanel.getEnumStrings());
                this.addRow(this.elanConfigModeFieldLabel, (Component)singleChoiceInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxElanModel.ElanDetails.ElanConfigModeEnum.symbolicValues, AtmxElanModel.ElanDetails.ElanConfigModeEnum.numericValues, ElanInfoBasePanel.getEnumStrings());
            this.addRow(this.elanConfigModeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getelanConfigModeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanConfigModeField);
            this.validateelanConfigModeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanConfigModeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanConfigModeField);
                jDMInput.setValue(object);
                this.validateelanConfigModeField();
            }
        }

        protected boolean validateelanConfigModeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanConfigModeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanConfigModeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanConfigModeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanUseDefaultLecsAddrField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanUseDefaultLecsAddr.access", "read-write");
            this.elanUseDefaultLecsAddrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanUseDefaultLecsAddrFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanUseDefaultLecsAddrLabel"), 2);
            if (this.elanUseDefaultLecsAddrFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.elanUseDefaultLecsAddrFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanUseDefaultLecsAddrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanUseDefaultLecsAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanUseDefaultLecsAddrField);
            this.validateelanUseDefaultLecsAddrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanUseDefaultLecsAddrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanUseDefaultLecsAddrField);
                jDMInput.setValue(object);
                this.validateelanUseDefaultLecsAddrField();
            }
        }

        protected boolean validateelanUseDefaultLecsAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanUseDefaultLecsAddrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanUseDefaultLecsAddrFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanUseDefaultLecsAddrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanLecsAtmAddressField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLecsAtmAddress.access", "read-write");
            ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLecsAtmAddress.length", "1024");
            this.elanLecsAtmAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanLecsAtmAddressFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanLecsAtmAddressLabel"), 2);
            if (this.elanLecsAtmAddressFieldWritable) {
                StringInput stringInput = new StringInput();
                this.addRow(this.elanLecsAtmAddressFieldLabel, (Component)stringInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanLecsAtmAddressFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanLecsAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLecsAtmAddressField);
            this.validateelanLecsAtmAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanLecsAtmAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanLecsAtmAddressField);
                jDMInput.setValue(object);
                this.validateelanLecsAtmAddressField();
            }
        }

        protected boolean validateelanLecsAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLecsAtmAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanLecsAtmAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanLecsAtmAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanLesAtmAddressField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLesAtmAddress.access", "read-write");
            ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanLesAtmAddress.length", "1024");
            this.elanLesAtmAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanLesAtmAddressFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanLesAtmAddressLabel"), 2);
            if (this.elanLesAtmAddressFieldWritable) {
                StringInput stringInput = new StringInput();
                this.addRow(this.elanLesAtmAddressFieldLabel, (Component)stringInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanLesAtmAddressFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanLesAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLesAtmAddressField);
            this.validateelanLesAtmAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanLesAtmAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanLesAtmAddressField);
                jDMInput.setValue(object);
                this.validateelanLesAtmAddressField();
            }
        }

        protected boolean validateelanLesAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanLesAtmAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanLesAtmAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanLesAtmAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.elanIndexField = this.createelanIndexField();
            this.elanLanNameField = this.createelanLanNameField();
            this.elanLanTypeField = this.createelanLanTypeField();
            this.elanMaxDataFrameSizeField = this.createelanMaxDataFrameSizeField();
            this.elanConfigModeField = this.createelanConfigModeField();
            this.elanUseDefaultLecsAddrField = this.createelanUseDefaultLecsAddrField();
            this.elanLecsAtmAddressField = this.createelanLecsAtmAddressField();
            this.elanLesAtmAddressField = this.createelanLesAtmAddressField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.elanIndexField)).ignoreValue() && this.elanIndexFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanIndex", this.getelanIndexField());
                }
                if (!((JDMInput)((Object)this.elanLanNameField)).ignoreValue() && this.elanLanNameFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanLanName", this.getelanLanNameField());
                }
                if (!((JDMInput)((Object)this.elanLanTypeField)).ignoreValue() && this.elanLanTypeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanLanType", this.getelanLanTypeField());
                }
                if (!((JDMInput)((Object)this.elanMaxDataFrameSizeField)).ignoreValue() && this.elanMaxDataFrameSizeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanMaxDataFrameSize", this.getelanMaxDataFrameSizeField());
                }
                if (!((JDMInput)((Object)this.elanConfigModeField)).ignoreValue() && this.elanConfigModeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanConfigMode", this.getelanConfigModeField());
                }
                if (!((JDMInput)((Object)this.elanUseDefaultLecsAddrField)).ignoreValue() && this.elanUseDefaultLecsAddrFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanUseDefaultLecsAddr", this.getelanUseDefaultLecsAddrField());
                }
                if (!((JDMInput)((Object)this.elanLecsAtmAddressField)).ignoreValue() && this.elanLecsAtmAddressFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanLecsAtmAddress", this.getelanLecsAtmAddressField());
                }
                if (!((JDMInput)((Object)this.elanLesAtmAddressField)).ignoreValue() && this.elanLesAtmAddressFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanLesAtmAddress", this.getelanLesAtmAddressField());
                    return;
                }
            } else {
                ElanInfoBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setelanIndexField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanIndex", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanLanNameField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLanName", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanLanTypeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLanType", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanMaxDataFrameSizeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxDataFrameSize", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanConfigModeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanConfigMode", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanUseDefaultLecsAddrField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanUseDefaultLecsAddr", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanLecsAtmAddressField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLecsAtmAddress", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanLesAtmAddressField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLesAtmAddress", ElanInfoBasePanel.this.ElanTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            ElanInfoBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setelanIndexField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanIndex", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanLanNameField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLanName", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanLanTypeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLanType", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanMaxDataFrameSizeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxDataFrameSize", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanConfigModeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanConfigMode", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanUseDefaultLecsAddrField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanUseDefaultLecsAddr", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanLecsAtmAddressField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLecsAtmAddress", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanLesAtmAddressField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanLesAtmAddress", ElanInfoBasePanel.this.ElanTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.elanLanNameField)).ignoreValue() && !this.validateelanLanNameField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanLecsAtmAddressField)).ignoreValue() && !this.validateelanLecsAtmAddressField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanMaxDataFrameSizeField)).ignoreValue() && !this.validateelanMaxDataFrameSizeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanLanTypeField)).ignoreValue() && !this.validateelanLanTypeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanLesAtmAddressField)).ignoreValue() && !this.validateelanLesAtmAddressField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanConfigModeField)).ignoreValue() && !this.validateelanConfigModeField()) {
                return false;
            }
            return ((JDMInput)((Object)this.elanUseDefaultLecsAddrField)).ignoreValue() || this.validateelanUseDefaultLecsAddrField();
        }
    }

    public class ElanCfgTimersSection
    extends PropertySection {
        ModelInfo chunk;
        Component elanAgingTimeField;
        Component elanControlTimeoutField;
        Component elanVccTimeoutPeriodField;
        Component elanFlushTimeOutField;
        Component elanExpectedArpRespTimeField;
        Component elanMaxRetryCountField;
        Component elanMaxUnknownFrameCountField;
        Component elanMaxUnknownFrameTimeField;
        Component elanUseForwardDelayField;
        Component elanForwardDelayTimeField;
        Component elanPathSwitchingDelayField;
        Component elanUseTranslationField;
        Label elanAgingTimeFieldLabel;
        Label elanControlTimeoutFieldLabel;
        Label elanVccTimeoutPeriodFieldLabel;
        Label elanFlushTimeOutFieldLabel;
        Label elanExpectedArpRespTimeFieldLabel;
        Label elanMaxRetryCountFieldLabel;
        Label elanMaxUnknownFrameCountFieldLabel;
        Label elanMaxUnknownFrameTimeFieldLabel;
        Label elanUseForwardDelayFieldLabel;
        Label elanForwardDelayTimeFieldLabel;
        Label elanPathSwitchingDelayFieldLabel;
        Label elanUseTranslationFieldLabel;
        boolean elanAgingTimeFieldWritable = false;
        boolean elanControlTimeoutFieldWritable = false;
        boolean elanVccTimeoutPeriodFieldWritable = false;
        boolean elanFlushTimeOutFieldWritable = false;
        boolean elanExpectedArpRespTimeFieldWritable = false;
        boolean elanMaxRetryCountFieldWritable = false;
        boolean elanMaxUnknownFrameCountFieldWritable = false;
        boolean elanMaxUnknownFrameTimeFieldWritable = false;
        boolean elanUseForwardDelayFieldWritable = false;
        boolean elanForwardDelayTimeFieldWritable = false;
        boolean elanPathSwitchingDelayFieldWritable = false;
        boolean elanUseTranslationFieldWritable = false;

        public ElanCfgTimersSection() {
            ElanInfoBasePanel.this = ElanInfoBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createelanAgingTimeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanAgingTime.access", "read-write");
            this.elanAgingTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanAgingTimeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanAgingTimeLabel"), 2);
            if (this.elanAgingTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(10, 300);
                this.addRow(this.elanAgingTimeFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanAgingTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanAgingTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanAgingTimeField);
            this.validateelanAgingTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanAgingTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanAgingTimeField);
                jDMInput.setValue(object);
                this.validateelanAgingTimeField();
            }
        }

        protected boolean validateelanAgingTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanAgingTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanAgingTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanAgingTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanControlTimeoutField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanControlTimeout.access", "read-write");
            this.elanControlTimeoutFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanControlTimeoutFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanControlTimeoutLabel"), 2);
            if (this.elanControlTimeoutFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(10, 300);
                this.addRow(this.elanControlTimeoutFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanControlTimeoutFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanControlTimeoutField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanControlTimeoutField);
            this.validateelanControlTimeoutField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanControlTimeoutField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanControlTimeoutField);
                jDMInput.setValue(object);
                this.validateelanControlTimeoutField();
            }
        }

        protected boolean validateelanControlTimeoutField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanControlTimeoutField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanControlTimeoutFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanControlTimeoutFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanVccTimeoutPeriodField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanVccTimeoutPeriod.access", "read-write");
            this.elanVccTimeoutPeriodFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanVccTimeoutPeriodFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanVccTimeoutPeriodLabel"), 2);
            if (this.elanVccTimeoutPeriodFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.elanVccTimeoutPeriodFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanVccTimeoutPeriodFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanVccTimeoutPeriodField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanVccTimeoutPeriodField);
            this.validateelanVccTimeoutPeriodField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanVccTimeoutPeriodField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanVccTimeoutPeriodField);
                jDMInput.setValue(object);
                this.validateelanVccTimeoutPeriodField();
            }
        }

        protected boolean validateelanVccTimeoutPeriodField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanVccTimeoutPeriodField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanVccTimeoutPeriodFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanVccTimeoutPeriodFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanFlushTimeOutField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanFlushTimeOut.access", "read-write");
            this.elanFlushTimeOutFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanFlushTimeOutFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanFlushTimeOutLabel"), 2);
            if (this.elanFlushTimeOutFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 4);
                this.addRow(this.elanFlushTimeOutFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanFlushTimeOutFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanFlushTimeOutField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanFlushTimeOutField);
            this.validateelanFlushTimeOutField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanFlushTimeOutField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanFlushTimeOutField);
                jDMInput.setValue(object);
                this.validateelanFlushTimeOutField();
            }
        }

        protected boolean validateelanFlushTimeOutField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanFlushTimeOutField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanFlushTimeOutFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanFlushTimeOutFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanExpectedArpRespTimeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanExpectedArpResponseTime.access", "read-write");
            this.elanExpectedArpRespTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanExpectedArpRespTimeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanExpectedArpRespTimeLabel"), 2);
            if (this.elanExpectedArpRespTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 30);
                this.addRow(this.elanExpectedArpRespTimeFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanExpectedArpRespTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanExpectedArpRespTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanExpectedArpRespTimeField);
            this.validateelanExpectedArpRespTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanExpectedArpRespTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanExpectedArpRespTimeField);
                jDMInput.setValue(object);
                this.validateelanExpectedArpRespTimeField();
            }
        }

        protected boolean validateelanExpectedArpRespTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanExpectedArpRespTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanExpectedArpRespTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanExpectedArpRespTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanMaxRetryCountField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanMaxRetryCount.access", "read-write");
            this.elanMaxRetryCountFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanMaxRetryCountFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanMaxRetryCountLabel"), 2);
            if (this.elanMaxRetryCountFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 2);
                this.addRow(this.elanMaxRetryCountFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanMaxRetryCountFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanMaxRetryCountField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxRetryCountField);
            this.validateelanMaxRetryCountField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanMaxRetryCountField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanMaxRetryCountField);
                jDMInput.setValue(object);
                this.validateelanMaxRetryCountField();
            }
        }

        protected boolean validateelanMaxRetryCountField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxRetryCountField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanMaxRetryCountFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanMaxRetryCountFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanMaxUnknownFrameCountField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanMaxUnknownFrameCount.access", "read-write");
            this.elanMaxUnknownFrameCountFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanMaxUnknownFrameCountFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanMaxUnknownFrameCountLabel"), 2);
            if (this.elanMaxUnknownFrameCountFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 10);
                this.addRow(this.elanMaxUnknownFrameCountFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanMaxUnknownFrameCountFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanMaxUnknownFrameCountField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxUnknownFrameCountField);
            this.validateelanMaxUnknownFrameCountField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanMaxUnknownFrameCountField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanMaxUnknownFrameCountField);
                jDMInput.setValue(object);
                this.validateelanMaxUnknownFrameCountField();
            }
        }

        protected boolean validateelanMaxUnknownFrameCountField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxUnknownFrameCountField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanMaxUnknownFrameCountFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanMaxUnknownFrameCountFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanMaxUnknownFrameTimeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanMaxUnknownFrameTime.access", "read-write");
            this.elanMaxUnknownFrameTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanMaxUnknownFrameTimeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanMaxUnknownFrameTimeLabel"), 2);
            if (this.elanMaxUnknownFrameTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 60);
                this.addRow(this.elanMaxUnknownFrameTimeFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanMaxUnknownFrameTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanMaxUnknownFrameTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxUnknownFrameTimeField);
            this.validateelanMaxUnknownFrameTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanMaxUnknownFrameTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanMaxUnknownFrameTimeField);
                jDMInput.setValue(object);
                this.validateelanMaxUnknownFrameTimeField();
            }
        }

        protected boolean validateelanMaxUnknownFrameTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanMaxUnknownFrameTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanMaxUnknownFrameTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanMaxUnknownFrameTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanUseForwardDelayField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanUseForwardDelay.access", "read-write");
            this.elanUseForwardDelayFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanUseForwardDelayFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanUseForwardDelayLabel"), 2);
            if (this.elanUseForwardDelayFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 2);
                this.addRow(this.elanUseForwardDelayFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanUseForwardDelayFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanUseForwardDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanUseForwardDelayField);
            this.validateelanUseForwardDelayField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanUseForwardDelayField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanUseForwardDelayField);
                jDMInput.setValue(object);
                this.validateelanUseForwardDelayField();
            }
        }

        protected boolean validateelanUseForwardDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanUseForwardDelayField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanUseForwardDelayFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanUseForwardDelayFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanForwardDelayTimeField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanForwardDelayTime.access", "read-write");
            this.elanForwardDelayTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanForwardDelayTimeFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanForwardDelayTimeLabel"), 2);
            if (this.elanForwardDelayTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(4, 30);
                this.addRow(this.elanForwardDelayTimeFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanForwardDelayTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanForwardDelayTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanForwardDelayTimeField);
            this.validateelanForwardDelayTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanForwardDelayTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanForwardDelayTimeField);
                jDMInput.setValue(object);
                this.validateelanForwardDelayTimeField();
            }
        }

        protected boolean validateelanForwardDelayTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanForwardDelayTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanForwardDelayTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanForwardDelayTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanPathSwitchingDelayField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanPathSwitchingDelay.access", "read-write");
            this.elanPathSwitchingDelayFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanPathSwitchingDelayFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanPathSwitchingDelayLabel"), 2);
            if (this.elanPathSwitchingDelayFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 8);
                this.addRow(this.elanPathSwitchingDelayFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanPathSwitchingDelayFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanPathSwitchingDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanPathSwitchingDelayField);
            this.validateelanPathSwitchingDelayField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanPathSwitchingDelayField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanPathSwitchingDelayField);
                jDMInput.setValue(object);
                this.validateelanPathSwitchingDelayField();
            }
        }

        protected boolean validateelanPathSwitchingDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanPathSwitchingDelayField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanPathSwitchingDelayFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanPathSwitchingDelayFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createelanUseTranslationField() {
            String string = ElanInfoBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxElan.ElanDetails.ElanUseTranslation.access", "read-write");
            this.elanUseTranslationFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.elanUseTranslationFieldLabel = new Label(ElanInfoBasePanel.getNLSString("elanUseTranslationLabel"), 2);
            if (this.elanUseTranslationFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 2);
                this.addRow(this.elanUseTranslationFieldLabel, (Component)numericInput);
                ElanInfoBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.elanUseTranslationFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getelanUseTranslationField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanUseTranslationField);
            this.validateelanUseTranslationField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setelanUseTranslationField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.elanUseTranslationField);
                jDMInput.setValue(object);
                this.validateelanUseTranslationField();
            }
        }

        protected boolean validateelanUseTranslationField() {
            JDMInput jDMInput = (JDMInput)((Object)this.elanUseTranslationField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.elanUseTranslationFieldLabel.setForeground(Color.yellow);
            } else {
                this.elanUseTranslationFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.elanAgingTimeField = this.createelanAgingTimeField();
            this.elanControlTimeoutField = this.createelanControlTimeoutField();
            this.elanVccTimeoutPeriodField = this.createelanVccTimeoutPeriodField();
            this.elanFlushTimeOutField = this.createelanFlushTimeOutField();
            this.elanExpectedArpRespTimeField = this.createelanExpectedArpRespTimeField();
            this.elanMaxRetryCountField = this.createelanMaxRetryCountField();
            this.elanMaxUnknownFrameCountField = this.createelanMaxUnknownFrameCountField();
            this.elanMaxUnknownFrameTimeField = this.createelanMaxUnknownFrameTimeField();
            this.elanUseForwardDelayField = this.createelanUseForwardDelayField();
            this.elanForwardDelayTimeField = this.createelanForwardDelayTimeField();
            this.elanPathSwitchingDelayField = this.createelanPathSwitchingDelayField();
            this.elanUseTranslationField = this.createelanUseTranslationField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.elanAgingTimeField)).ignoreValue() && this.elanAgingTimeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanAgingTime", this.getelanAgingTimeField());
                }
                if (!((JDMInput)((Object)this.elanControlTimeoutField)).ignoreValue() && this.elanControlTimeoutFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanControlTimeout", this.getelanControlTimeoutField());
                }
                if (!((JDMInput)((Object)this.elanVccTimeoutPeriodField)).ignoreValue() && this.elanVccTimeoutPeriodFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanVccTimeoutPeriod", this.getelanVccTimeoutPeriodField());
                }
                if (!((JDMInput)((Object)this.elanFlushTimeOutField)).ignoreValue() && this.elanFlushTimeOutFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanFlushTimeOut", this.getelanFlushTimeOutField());
                }
                if (!((JDMInput)((Object)this.elanExpectedArpRespTimeField)).ignoreValue() && this.elanExpectedArpRespTimeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanExpectedArpResponseTime", this.getelanExpectedArpRespTimeField());
                }
                if (!((JDMInput)((Object)this.elanMaxRetryCountField)).ignoreValue() && this.elanMaxRetryCountFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanMaxRetryCount", this.getelanMaxRetryCountField());
                }
                if (!((JDMInput)((Object)this.elanMaxUnknownFrameCountField)).ignoreValue() && this.elanMaxUnknownFrameCountFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanMaxUnknownFrameCount", this.getelanMaxUnknownFrameCountField());
                }
                if (!((JDMInput)((Object)this.elanMaxUnknownFrameTimeField)).ignoreValue() && this.elanMaxUnknownFrameTimeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanMaxUnknownFrameTime", this.getelanMaxUnknownFrameTimeField());
                }
                if (!((JDMInput)((Object)this.elanUseForwardDelayField)).ignoreValue() && this.elanUseForwardDelayFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanUseForwardDelay", this.getelanUseForwardDelayField());
                }
                if (!((JDMInput)((Object)this.elanForwardDelayTimeField)).ignoreValue() && this.elanForwardDelayTimeFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanForwardDelayTime", this.getelanForwardDelayTimeField());
                }
                if (!((JDMInput)((Object)this.elanPathSwitchingDelayField)).ignoreValue() && this.elanPathSwitchingDelayFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanPathSwitchingDelay", this.getelanPathSwitchingDelayField());
                }
                if (!((JDMInput)((Object)this.elanUseTranslationField)).ignoreValue() && this.elanUseTranslationFieldWritable) {
                    ElanInfoBasePanel.this.ElanDetailsInfo.add("ElanDetails.ElanUseTranslation", this.getelanUseTranslationField());
                    return;
                }
            } else {
                ElanInfoBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setelanAgingTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanAgingTime", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanControlTimeoutField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanControlTimeout", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanVccTimeoutPeriodField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanVccTimeoutPeriod", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanFlushTimeOutField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanFlushTimeOut", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanExpectedArpRespTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanExpectedArpResponseTime", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanMaxRetryCountField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxRetryCount", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanMaxUnknownFrameCountField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxUnknownFrameCount", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanMaxUnknownFrameTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxUnknownFrameTime", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanUseForwardDelayField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanUseForwardDelay", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanForwardDelayTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanForwardDelayTime", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanPathSwitchingDelayField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanPathSwitchingDelay", ElanInfoBasePanel.this.ElanTableIndex));
                this.setelanUseTranslationField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanUseTranslation", ElanInfoBasePanel.this.ElanTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            ElanInfoBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setelanAgingTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanAgingTime", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanControlTimeoutField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanControlTimeout", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanVccTimeoutPeriodField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanVccTimeoutPeriod", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanFlushTimeOutField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanFlushTimeOut", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanExpectedArpRespTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanExpectedArpResponseTime", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanMaxRetryCountField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxRetryCount", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanMaxUnknownFrameCountField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxUnknownFrameCount", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanMaxUnknownFrameTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanMaxUnknownFrameTime", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanUseForwardDelayField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanUseForwardDelay", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanForwardDelayTimeField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanForwardDelayTime", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanPathSwitchingDelayField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanPathSwitchingDelay", ElanInfoBasePanel.this.ElanTableIndex));
            this.setelanUseTranslationField(ElanInfoBasePanel.this.ElanTableData.getValueAt("ElanDetails.ElanUseTranslation", ElanInfoBasePanel.this.ElanTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.elanExpectedArpRespTimeField)).ignoreValue() && !this.validateelanExpectedArpRespTimeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanUseTranslationField)).ignoreValue() && !this.validateelanUseTranslationField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanUseForwardDelayField)).ignoreValue() && !this.validateelanUseForwardDelayField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanFlushTimeOutField)).ignoreValue() && !this.validateelanFlushTimeOutField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanVccTimeoutPeriodField)).ignoreValue() && !this.validateelanVccTimeoutPeriodField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanControlTimeoutField)).ignoreValue() && !this.validateelanControlTimeoutField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanMaxUnknownFrameCountField)).ignoreValue() && !this.validateelanMaxUnknownFrameCountField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanPathSwitchingDelayField)).ignoreValue() && !this.validateelanPathSwitchingDelayField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanMaxRetryCountField)).ignoreValue() && !this.validateelanMaxRetryCountField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanMaxUnknownFrameTimeField)).ignoreValue() && !this.validateelanMaxUnknownFrameTimeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.elanForwardDelayTimeField)).ignoreValue() && !this.validateelanForwardDelayTimeField()) {
                return false;
            }
            return ((JDMInput)((Object)this.elanAgingTimeField)).ignoreValue() || this.validateelanAgingTimeField();
        }
    }

    public class ElanTable
    extends Table {
        public ModelInfo setRow() {
            try {
                ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("startSendMsg"));
                ElanInfoBasePanel.this.ElanDetailsInfo = ElanInfoBasePanel.this.AtmxElan_model.setInfo("ElanDetails", ElanInfoBasePanel.this.ElanDetailsInfo);
                ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("endSendMsg"));
                if (ElanInfoBasePanel.this.ElanDetailsInfo != null) {
                    Enumeration enumeration = ElanInfoBasePanel.this.ElanDetailsInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = ElanInfoBasePanel.this.ElanDetailsInfo.get(string);
                        ElanInfoBasePanel.this.ElanTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return ElanInfoBasePanel.this.ElanTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    ElanInfoBasePanel.this.ElanTableInfo = null;
                    ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("startRow"));
                    ElanInfoBasePanel.this.ElanDetailsInfo = ElanInfoBasePanel.this.AtmxElan_model.getNextInfo("ElanDetails", "default", modelInfo);
                    ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("endRow"));
                    if (ElanInfoBasePanel.this.ElanDetailsInfo != null) {
                        ElanInfoBasePanel.this.ElanTableInfo = new ModelInfo();
                        if (ElanInfoBasePanel.this.ElanDetailsInfo.isBeingMonitored()) {
                            ElanInfoBasePanel.this.ElanTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = ElanInfoBasePanel.this.ElanDetailsInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = ElanInfoBasePanel.this.ElanDetailsInfo.get(string);
                            ElanInfoBasePanel.this.ElanTableInfo.add(string, serializable);
                        }
                    }
                    if (ElanInfoBasePanel.this.ElanTableInfo != null && !this.validRow(ElanInfoBasePanel.this.ElanTableInfo)) {
                        modelInfo = ElanInfoBasePanel.this.ElanTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return ElanInfoBasePanel.this.ElanTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            ElanInfoBasePanel.this.ElanTableInfo = null;
            try {
                ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("startRow"));
                ElanInfoBasePanel.this.ElanDetailsInfo = ElanInfoBasePanel.this.AtmxElan_model.getInfo("ElanDetails", "default", modelInfo);
                ElanInfoBasePanel.this.displayMsg(ElanInfoBasePanel.getNLSString("endRow"));
                if (ElanInfoBasePanel.this.ElanDetailsInfo != null) {
                    ElanInfoBasePanel.this.ElanTableInfo = new ModelInfo();
                    if (ElanInfoBasePanel.this.ElanDetailsInfo.isBeingMonitored()) {
                        ElanInfoBasePanel.this.ElanTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = ElanInfoBasePanel.this.ElanDetailsInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = ElanInfoBasePanel.this.ElanDetailsInfo.get(string);
                        ElanInfoBasePanel.this.ElanTableInfo.add(string, serializable);
                    }
                }
                if (ElanInfoBasePanel.this.ElanTableInfo != null && !this.validRow(ElanInfoBasePanel.this.ElanTableInfo)) {
                    ElanInfoBasePanel.this.ElanTableInfo = this.getRow(ElanInfoBasePanel.this.ElanTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return ElanInfoBasePanel.this.ElanTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (ElanInfoBasePanel.this.ElanTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            ElanInfoBasePanel.this.ElanTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        ElanInfoBasePanel.this.ElanTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        ElanInfoBasePanel.this.ElanTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    ElanInfoBasePanel.this.ElanTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("ElanDetails.ElanLanType")) {
                    string2 = enumStrings.getString(AtmxElanModel.ElanDetails.ElanLanTypeEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public ElanTable() {
            ElanInfoBasePanel.this = ElanInfoBasePanel.this;
        }
    }
}

